IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_PRECO_DESC_QTDE_PBM_CPL')
BEGIN
CREATE TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL](
	[CD_EMP] [int] NOT NULL,
	[CD_CONV_PBM] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[QT_PROD] [money] NOT NULL,
	[PERC_DESC_QTDE] [money] NULL,
 CONSTRAINT [PK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_CONV_PBM] ASC,
	[CD_PROD] ASC,
	[QT_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_QT_PROD')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL] ADD  CONSTRAINT [DF_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_QT_PROD]  DEFAULT ((0)) FOR [QT_PROD]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_PERC_DESC_QTDE')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL] ADD  CONSTRAINT [DF_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_PERC_DESC_QTDE]  DEFAULT ((0)) FOR [PERC_DESC_QTDE]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD_PRECO_DESC_QTDE')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD_PRECO_DESC_QTDE] FOREIGN KEY ([CD_EMP], [CD_CONV_PBM])
	REFERENCES [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM] ([CD_EMP], [CD_CONV_PBM])
	ON UPDATE CASCADE
	ON DELETE CASCADE
END

ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL] CHECK CONSTRAINT [FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD_PRECO_DESC_QTDE]
GO


IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
	REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_PRECO_DESC_QTDE_PBM_CPL] CHECK CONSTRAINT [FK_EST_PROD_PRECO_DESC_QTDE_PBM_CPL_EST_PROD]
END
GO
